/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Date;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;

public class Screen
extends Canvas
implements Runnable,
CommandListener {
    BusiMan app;
    RecordStore recordStore;
    private static Random rnd;
    private Date date;
    private int stime = 0;
    private int volume = 0;
    public Command exitCommand = new Command("Exit", 1, 11);
    public Command startCommand = new Command("Menu", 1, 1);
    public Command titleCommand = new Command("Title", 1, 10);
    public Command pauseCommand = new Command("Pause", 1, 0);
    public Command resumeCommand = new Command("Resume", 1, 0);
    public Command nextCommand = new Command("Next", 1, 1);
    public Command bonusCommand = new Command("Bonus", 1, 1);
    public Command retryCommand = new Command("Restart", 1, 0);
    public Command okCommand = new Command("YES", 1, 1);
    public Command cancelCommand = new Command("NO", 1, 9);
    public Command playCommand = new Command("Start", 4, 0);
    public Command[] cmd = new Command[2];
    private boolean loaded = false;
    private int progress = 0;
    private boolean showintro = false;
    public int gState = 0;
    private boolean loop = true;
    private boolean lock = false;
    private boolean practice = false;
    public int level = 1;
    private int score = 0;
    private int success = 0;
    private int life = 0;
    private int winsize = 0;
    private int once = 0;
    private int wtime = 0;
    private int clrcond = 0;
    private int hand = 1;
    private int TID = 0;
    private BMan[] npcs;
    public int prevState1;
    public int prevState2;
    private int blink;
    private int selidx = 0;
    private int temp = 0;
    private int timer = 0;
    private int count;
    private int btime;
    private int bscore;
    private int blife;
    private int pressed;
    private static final int VK_UP = -1;
    private static final int VK_LEFT = -3;
    private static final int VK_RIGHT = -4;
    private static final int VK_DOWN = -2;
    private static final int VK_OK = -5;
    private static final int VK_SOFT1 = 21;
    private static final int VK_SOFT2 = 22;
    private static final int VK_STAR = 42;
    private static final int VK_NUM1 = 49;
    private static final int VK_NUM2 = 50;
    private static final int VK_NUM3 = 51;
    private static final int VK_NUM4 = 52;
    private static final int VK_NUM5 = 53;
    private static final int VK_NUM6 = 54;
    private static final int VK_NUM7 = 55;
    private static final int VK_NUM8 = 56;
    private static final int VK_NUM9 = 57;
    private boolean canPause;
    private static final String[] helpdoc;
    private static final String[] introdoc;
    private static final int interval = 100;
    private static final int speed = 13;
    private static final int LAST = 15;
    private static final int[] winsize_data;
    private static final int[] once_data;
    private static final int[] wtime_data;
    private static final int[] clrcond_data;
    public static final int NPC_SIDE = 59;
    public static final int PC_SIDE = 100;
    public static final int LOADING = 0;
    public static final int WELCOME = 1;
    public static final int MENU = 2;
    public static final int READY = 3;
    public static final int PLAY = 4;
    public static final int CLEAR = 5;
    public static final int ALLCLEAR = 6;
    public static final int GAMEOVER = 7;
    public static final int BONUS2 = 9;
    public static final int BREADY2 = 11;
    public static final int BONUSEND2 = 13;
    public static final int HELP = 14;
    public static final int INTROHELP = 15;
    public static final int PAUSE = 16;
    public static final int EXIT = 17;
    public static final int TUTORIAL = 18;
    public static final int TITLE_Q = 19;
    public static final int WHITE = 0xFFFFFF;
    public static final int LGRAY = 0xC0C0C0;
    public static final int DGRAY = 0x808080;
    public static final int BLACK = 0;
    public static final int TURQUOISE = 2138562;
    public static final int RED = 0xFF0000;
    public static final int anchor = 20;
    public static Image title;
    public static Image logo;
    public static Image tail;
    public static Image corner;
    public static Image[] npcimg;
    public static Image goodimg;
    public static Image badimg;
    public static Image punchimg;
    public static Image cardimg;
    public static Image handimg1;
    public static Image handimg2;
    public static Image money;
    public static Image goods;
    public static Image trash;
    public static Image comp;
    public static Image heart;
    public static Image coin;
    public static Image hole;
    public static Image glove;
    public static Image star;
    public static Image press;
    public static Image text;
    public static Image msgbonus;
    public static Image msghelp;
    public static Image key6;
    public static Image btn;
    public static Image loadmsg;
    public static Image imgSndOff;
    private boolean bSndOff = false;

    public Screen(BusiMan busiMan) {
        this.app = busiMan;
        rnd = new Random();
        this.npcs = new BMan[6];
        int n = 0;
        while (n < 6) {
            this.npcs[n] = new BMan();
            ++n;
        }
        loadmsg = this.loadImage("loading.png");
        this.progress = 0;
        this.setCommandListener(this);
        Thread thread = new Thread(this);
        thread.start();
    }

    private void playSound(int n) {
        if (!this.bSndOff) {
            // empty if block
        }
    }

    private void removeAllCommands() {
        this.removeCommand(this.exitCommand);
        this.removeCommand(this.startCommand);
        this.removeCommand(this.titleCommand);
        this.removeCommand(this.pauseCommand);
        this.removeCommand(this.resumeCommand);
        this.removeCommand(this.nextCommand);
        this.removeCommand(this.bonusCommand);
        this.removeCommand(this.retryCommand);
        this.removeCommand(this.okCommand);
        this.removeCommand(this.cancelCommand);
        this.removeCommand(this.playCommand);
    }

    public void doPause() {
        if (this.canPause) {
            this.prevState1 = this.gState;
            this.update(16);
        }
    }

    public void update(int n) {
        this.cmd[0] = null;
        this.cmd[1] = null;
        this.canPause = false;
        if (n == 1) {
            this.cmd[0] = this.startCommand;
            this.cmd[1] = this.exitCommand;
        } else if (n == 2) {
            this.blink = 0xFFFF66;
            this.selidx = 0;
            this.cmd[0] = this.playCommand;
            this.cmd[1] = this.exitCommand;
        } else if (n == 14) {
            this.blink = 0xFFFF66;
            this.selidx = 0;
            this.cmd[0] = this.startCommand;
            this.cmd[1] = this.playCommand;
        } else if (n == 5 || n == 6) {
            this.cmd[0] = this.practice ? (n == 6 ? this.retryCommand : this.nextCommand) : (n == 6 ? this.retryCommand : this.nextCommand);
            this.cmd[1] = this.titleCommand;
        } else if (n == 7) {
            this.cmd[0] = this.retryCommand;
            this.cmd[1] = this.titleCommand;
        } else if (n == 11) {
            int n2 = 0;
            while (n2 < 6) {
                this.npcs[n2].npcType = -1;
                this.npcs[n2].aniStep = 0;
                this.npcs[n2].work = 0;
                if (n2 < 3) {
                    this.npcs[n2].resetPos(2 + 40 * n2, 35);
                } else {
                    this.npcs[n2].resetPos(2 + 40 * (n2 - 3), 74);
                }
                ++n2;
            }
            this.bscore = 0;
            this.blife = 0;
            this.btime = 30000;
            this.count = 4000;
            this.cmd[0] = this.okCommand;
            this.cmd[1] = this.titleCommand;
        } else if (n == 3) {
            this.cmd[0] = this.pauseCommand;
            this.cmd[1] = this.titleCommand;
        } else if (n == 13 || n == 15) {
            this.cmd[0] = this.okCommand;
            this.cmd[1] = this.titleCommand;
        } else if (n == 4) {
            this.canPause = true;
            this.cmd[0] = this.pauseCommand;
            this.cmd[1] = this.titleCommand;
        } else if (n == 9) {
            this.cmd[0] = this.pauseCommand;
            this.cmd[1] = this.titleCommand;
        } else if (n == 16) {
            this.cmd[0] = this.resumeCommand;
            this.cmd[1] = this.exitCommand;
        } else if (n == 19) {
            this.prevState2 = this.gState;
            this.cmd[0] = this.okCommand;
            this.cmd[1] = this.cancelCommand;
        } else if (n == 17) {
            this.prevState2 = this.gState;
            this.cmd[0] = this.okCommand;
            this.cmd[1] = this.cancelCommand;
        } else if (n == 18) {
            this.selidx = 0;
            this.blink = 0;
            this.newLevel(1);
            this.cmd[0] = this.pauseCommand;
            this.cmd[1] = this.titleCommand;
        }
        if (n == 11 || n == 9 || n == 3) {
            this.date = new Date();
            this.stime = (int)this.date.getTime();
        }
        this.removeAllCommands();
        if (this.cmd[0] != null) {
            this.addCommand(this.cmd[0]);
        }
        if (this.cmd[1] != null) {
            this.addCommand(this.cmd[1]);
        }
        this.gState = n;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
        if (this.gState == 0) {
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(0, 0, 120, 125);
            graphics.setColor(0xFFCC00);
            graphics.fillRect(0, 0, 120, 55);
            graphics.setColor(0x999999);
            graphics.drawRect(9, 58, 101, 5);
            graphics.drawRect(8, 59, 103, 3);
            graphics.setColor(0);
            graphics.drawRect(9, 59, 101, 3);
            this.temp = this.progress % 4;
            if (this.temp == 0) {
                graphics.setColor(0);
            } else if (this.temp == 1 || this.temp == 3) {
                graphics.setColor(0x996633);
            } else {
                graphics.setColor(0xFFCC00);
            }
            graphics.fillRect(27, 43, 75, 9);
            graphics.drawImage(loadmsg, 27, 43, 20);
            this.temp = 99 * this.progress / 38;
            if (this.temp > 99) {
                this.temp = 99;
            }
            graphics.setColor(0xFF6600);
            graphics.drawLine(10, 60, 10 + this.temp, 60);
            graphics.setColor(0xDD3300);
            graphics.drawLine(10, 61, 10 + this.temp, 61);
        } else if (this.gState == 15) {
            graphics.setColor(0x7DDEEE);
            graphics.fillRect(3, 8, 113, 92);
            graphics.setColor(1596837);
            graphics.drawRect(3, 8, 113, 92);
            graphics.setColor(0);
            graphics.drawString("[\uae0c?]", 60, 14, 17);
            int n = 0;
            while (n < 6) {
                graphics.drawString(introdoc[n], 6, 30 + n * 12, 20);
                ++n;
            }
        } else if (this.gState == 4 || this.gState == 3 || this.gState == 16) {
            this.drawGameBg(graphics);
            if (this.gState == 3 || this.gState == 16) {
                graphics.setColor(0xC0C0C0);
                graphics.fillRect(25, 63, 71, 14);
                graphics.setColor(0xFFFFFF);
                graphics.fillRect(25, 77, 71, 26);
                graphics.setColor(0);
                graphics.drawString("LEVEL " + this.level, 60, 65, 17);
                graphics.drawString("Mission", 60, 79, 17);
                graphics.drawImage(comp, 49, 91, 20);
                graphics.drawString("" + this.clrcond, 60, 90, 20);
            } else if (this.gState == 4) {
                graphics.drawImage(handimg1, 14 + this.hand * 38, 100, 20);
            }
            int n = 0;
            while (n < 3) {
                BMan bMan = this.npcs[n];
                if (bMan.work != 5 || Math.abs(bMan.aniStep) != 4 || bMan.aniStep > 0) {
                    // empty if block
                }
                bMan.paint(graphics, true);
                bMan.drawTrust(graphics);
                ++n;
            }
            if (this.practice && this.level <= 6 && this.level % 2 == 1) {
                int n2 = -1;
                int n3 = 0;
                while (n3 < 3) {
                    if (this.npcs[n3].work == 3) {
                        this.npcs[n3].drawRBox(graphics);
                        n2 = n3;
                    } else if (this.npcs[n3].work == 1 && this.npcs[n3].obj < 3) {
                        n2 = n3;
                    }
                    ++n3;
                }
                if (n2 >= 0) {
                    int n4 = 0;
                    if (this.npcs[n2].time / 300 % 2 == 0) {
                        n4 = 0xFF0000;
                    }
                    if (this.hand == n2) {
                        if (this.npcs[n2].work == 3) {
                            if (this.hand < 2) {
                                this.drawHBox(graphics, 14 + this.hand * 38 + 20, 87, this.npcs[n2].obj + 1, n4);
                            } else {
                                this.drawHBox(graphics, 14 + this.hand * 38 - 28, 87, this.npcs[n2].obj + 1, n4);
                            }
                        } else if (this.hand < 2) {
                            this.drawHBox(graphics, 14 + this.hand * 38 + 20, 87, 5, n4);
                        } else {
                            this.drawHBox(graphics, 14 + this.hand * 38 - 28, 87, 5, n4);
                        }
                    } else if (this.hand < n2) {
                        this.drawHBox(graphics, 14 + this.hand * 38 + 19, 87, 6, n4);
                    } else if (this.hand > n2) {
                        if (this.hand < 2) {
                            this.drawHBox(graphics, 14 + this.hand * 38 + 20, 87, 4, n4);
                        } else {
                            this.drawHBox(graphics, 14 + this.hand * 38 - 28, 87, 4, n4);
                        }
                    }
                }
            }
        } else if (this.gState == 5 || this.gState == 6) {
            this.drawGameBg(graphics);
            int n = 0;
            while (n < 3) {
                this.npcs[n].work = 5;
                this.npcs[n].aniStep = 1;
                this.npcs[n].paint(graphics, false);
                ++n;
            }
            graphics.setColor(0);
            if (this.gState == 5) {
                graphics.setClip(18, 75, 84, 9);
                graphics.drawImage(text, -9, 75, 20);
            } else {
                graphics.setClip(26, 70, 67, 9);
                graphics.drawImage(text, 26, 70, 20);
                graphics.setClip(41, 82, 38, 9);
                graphics.drawImage(text, -32, 82, 20);
            }
            graphics.setClip(0, 0, 120, 125);
        } else if (this.gState == 7) {
            this.drawGameBg(graphics);
            int n = 0;
            while (n < 3) {
                this.npcs[n].work = 5;
                this.npcs[n].aniStep = -1;
                this.npcs[n].paint(graphics, false);
                ++n;
            }
            graphics.setClip(26, 75, 69, 9);
            graphics.drawImage(text, -85, 75, 20);
            graphics.setClip(0, 0, 120, 125);
        } else if (this.gState == 9 || this.gState == 11) {
            this.bonusGame2(graphics);
        } else if (this.gState == 13) {
            this.bonusGame2(graphics);
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(37, 0, 45, 35);
            graphics.setColor(0);
            graphics.drawImage(msgbonus, 43, 2, 20);
            graphics.drawImage(heart, 42, 14, 20);
            graphics.drawString("" + this.blife, 56, 12, 20);
            graphics.drawImage(coin, 42, 24, 20);
            graphics.drawString("" + this.bscore, 56, 23, 20);
        } else if (this.gState == 2) {
            graphics.setColor(2138562);
            graphics.fillRect(0, 22, 120, 103);
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(0, 0, 120, 21);
            graphics.fillRect(26, 48, 69, 51);
            graphics.setClip(30, 50 + 12 * this.selidx, 11, 11);
            graphics.drawImage(money, 30, 47 + 12 * this.selidx, 20);
            graphics.setClip(0, 0, 120, 125);
            graphics.setColor(0);
            graphics.drawLine(0, 21, 120, 21);
            graphics.drawString("Start", 43, 50, 20);
            graphics.drawString("Practice", 43, 62, 20);
            graphics.drawString("Help", 43, 74, 20);
            graphics.drawString("Exit", 43, 86, 20);
            int n = 0;
            while (n < 3) {
                graphics.drawImage(npcimg[n], 3 + 38 * n, -17, 20);
                BMan.drawObj(graphics, 8 + 38 * n, 25, 0, n);
                ++n;
            }
        } else if (this.gState == 14) {
            graphics.setColor(2138562);
            graphics.fillRect(0, 0, 120, 125);
            graphics.drawImage(msghelp, 3, 1, 20);
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(3, 8, 113, 92);
            if (this.selidx != 0) {
                graphics.setColor(this.blink);
                graphics.fillRect(58, 3, 5, 6);
                graphics.fillRect(55, 6, 11, 3);
                graphics.setColor(0);
                graphics.drawLine(54, 9, 66, 9);
                graphics.drawLine(54, 8, 60, 2);
                graphics.drawLine(54, 7, 59, 2);
                graphics.drawLine(60, 2, 66, 8);
                graphics.drawLine(61, 2, 66, 7);
            }
            if (this.selidx != 3) {
                graphics.setColor(this.blink);
                graphics.fillRect(58, 100, 5, 6);
                graphics.fillRect(55, 100, 11, 3);
                graphics.setColor(0);
                graphics.drawLine(54, 99, 66, 99);
                graphics.drawLine(54, 100, 60, 106);
                graphics.drawLine(54, 101, 59, 106);
                graphics.drawLine(60, 106, 66, 100);
                graphics.drawLine(61, 106, 66, 101);
            }
            this.blink = this.blink == 0xFFFF66 ? 0x666666 : 0xFFFF66;
            if (this.selidx == 0) {
                graphics.drawString("When offered a", 5, 12, 20);
                graphics.drawString("card, accept and", 5, 26, 20);
                graphics.drawString("give a card when", 5, 40, 20);
                graphics.drawString("asked. When", 5, 54, 20);
                graphics.drawString("offered money,", 5, 68, 20);
                graphics.drawString("accept and give", 5, 82, 20);
            } else if (this.selidx == 1) {
                graphics.drawString("goods. When", 5, 12, 20);
                graphics.drawString("offered goods,", 5, 26, 20);
                graphics.drawString("accept and give", 5, 40, 20);
                graphics.drawString("money. When", 5, 54, 20);
                graphics.drawString("offered trash,", 5, 68, 20);
                graphics.drawString("dont accept.", 5, 82, 20);
            } else if (this.selidx == 2) {
                graphics.drawString("#1=Give Card", 5, 12, 20);
                graphics.drawString("#2=Give Money", 5, 26, 20);
                graphics.drawString("#3=Give Goods", 5, 40, 20);
                graphics.drawString("#4=Move left", 5, 54, 20);
                graphics.drawString("#6=Move right", 5, 68, 20);
                graphics.drawString("#5=Accept item", 5, 82, 20);
            } else if (this.selidx == 3) {
                graphics.drawImage(heart, 10, 16, 20);
                graphics.drawString("If the number", 22, 16, 20);
                graphics.drawString("next to the ", 22, 28, 20);
                graphics.drawString("heart = 0,", 22, 40, 20);
                graphics.drawString("the game ends", 22, 52, 20);
                graphics.drawImage(comp, 10, 71, 20);
                graphics.drawString(" =  # of happy ", 22, 69, 20);
                graphics.drawString("customers", 22, 81, 20);
            }
        } else if (this.gState == 1) {
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(0, 0, 120, 125);
            graphics.setColor(2138562);
            graphics.fillRect(0, 68, 120, 57);
            graphics.setColor(0);
            graphics.drawLine(0, 67, 120, 67);
            int n = 0;
            while (n < 3) {
                graphics.drawImage(npcimg[n], 3 + 38 * n, 29, 20);
                ++n;
            }
            this.blink = this.blink == 0xFFFFFF ? 2138562 : 0xFFFFFF;
            graphics.setColor(this.blink);
            graphics.drawString("PRESS ANY KEY", 60, 75, 17);
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(2, 2, 115, 27);
            graphics.setColor(0);
            graphics.drawRect(2, 2, 115, 27);
            int n5 = 0;
            while (n5 < 3) {
                graphics.drawImage(tail, 30 + 38 * n5, 29, 20);
                ++n5;
            }
            graphics.drawImage(logo, 20, 100, 20);
            if (this.bSndOff) {
                graphics.drawImage(imgSndOff, 3, 92, 20);
            }
            graphics.drawImage(title, 8, 9, 20);
            graphics.setClip(2, 2, 3, 3);
            graphics.drawImage(corner, 2, 2, 20);
            graphics.setClip(115, 2, 3, 3);
            graphics.drawImage(corner, 112, 2, 20);
            graphics.setClip(2, 27, 3, 3);
            graphics.drawImage(corner, 2, 24, 20);
            graphics.setClip(115, 27, 3, 3);
            graphics.drawImage(corner, 112, 24, 20);
        } else if (this.gState == 17) {
            this.drawExit(graphics);
        } else if (this.gState == 19) {
            this.drawTitleQ(graphics);
        } else if (this.gState == 18) {
            this.drawGameBg(graphics);
            graphics.drawImage(handimg1, 14 + this.hand * 38, 100, 20);
            int n = 0;
            while (n < 3) {
                BMan bMan = this.npcs[n];
                if (bMan.work == 5 && Math.abs(bMan.aniStep) == 4) {
                    if (bMan.aniStep > 0) {
                        this.playSound(3);
                    } else {
                        this.playSound(4);
                    }
                }
                bMan.paint(graphics, true);
                bMan.drawTrust(graphics);
                ++n;
            }
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(74, 60, 43, 45);
            graphics.setColor(0);
            graphics.drawRect(74, 60, 43, 45);
            graphics.drawImage(btn, 89, 92, 20);
            graphics.setColor(0);
            if (this.selidx == 0) {
                graphics.drawString("Left", 96, 62, 17);
                graphics.drawString("Move", 96, 73, 17);
                graphics.drawString("4", 93, 92, 20);
            } else if (this.selidx == 1) {
                graphics.drawString("Right", 96, 62, 17);
                graphics.drawString("Move", 96, 73, 17);
                graphics.drawString("6", 93, 92, 20);
            } else if (this.selidx == 2 || this.selidx == 4 || this.selidx == 6) {
                graphics.drawString("Receive", 96, 67, 17);
                graphics.drawString("5", 93, 92, 20);
            } else if (this.selidx == 3) {
                graphics.drawString("Card", 96, 62, 17);
                graphics.drawString("Give", 96, 73, 17);
                graphics.drawString("1", 93, 92, 20);
            } else if (this.selidx == 5) {
                graphics.drawString("Give", 96, 62, 17);
                graphics.drawString("Money", 96, 73, 17);
                graphics.drawString("2", 93, 92, 20);
            } else if (this.selidx == 7) {
                graphics.drawString("Give", 96, 62, 17);
                graphics.drawString("Goods", 96, 73, 17);
                graphics.drawString("3", 93, 92, 20);
            }
            if (this.blink < 5) {
                this.drawArrow(graphics, 92, 87);
                ++this.blink;
            } else if (this.blink <= 9) {
                this.drawArrow(graphics, 92, 84);
                this.blink = this.blink == 9 ? 0 : ++this.blink;
            }
            if (this.selidx == 8) {
                graphics.setColor(2138562);
                graphics.fillRect(0, 58, 120, 50);
                graphics.setColor(0xFFFFFF);
                graphics.fillRect(31, 59, 58, 47);
                graphics.setColor(0);
                graphics.drawRect(31, 59, 58, 47);
                graphics.drawImage(comp, 49, 65, 20);
                graphics.setColor(0);
                graphics.drawString("+1", 59, 64, 20);
                graphics.drawString("Start?", 60, 92, 17);
            }
        }
        if (this.gState == 16) {
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(42, 52, 37, 15);
            graphics.setColor(0);
            graphics.drawRect(42, 52, 37, 15);
            graphics.setColor(0xFF0000);
            graphics.drawString("PAUSE", 61, 54, 17);
        }
    }

    private void drawArrow(Graphics graphics, int n, int n2) {
        graphics.setColor(0xC60000);
        graphics.fillRect(n + 3, n2, 3, 9);
        graphics.fillRect(n + 1, n2 + 5, 7, 2);
        graphics.setColor(0xFF0000);
        graphics.drawLine(n + 2, n2, n + 2, n2 + 4);
        graphics.drawLine(n + 6, n2, n + 6, n2 + 4);
        graphics.drawLine(n, n2 + 5, n + 4, n2 + 9);
        graphics.drawLine(n + 8, n2 + 5, n + 4, n2 + 9);
    }

    void drawTitleQ(Graphics graphics) {
        graphics.setColor(0x7DDEEE);
        graphics.fillRect(0, 0, 120, 125);
        graphics.setColor(0);
        graphics.drawString("Return to  ", 17, 20, 0);
        graphics.drawString("the title  ", 17, 33, 0);
        graphics.drawString("page?", 17, 46, 0);
    }

    void drawExit(Graphics graphics) {
        graphics.setColor(0x7DDEEE);
        graphics.fillRect(0, 0, 120, 125);
        graphics.setColor(0);
        graphics.drawString("Would you", 17, 20, 0);
        graphics.drawString("like to quit?", 17, 33, 0);
    }

    private void bonusGame2(Graphics graphics) {
        graphics.setColor(2138562);
        graphics.fillRect(0, 0, 120, 95);
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 95, 119, 12);
        graphics.setColor(0);
        graphics.drawRect(0, 95, 119, 12);
        graphics.drawImage(heart, 3, 97, 20);
        graphics.drawString("" + this.blife, 15, 96, 20);
        graphics.drawImage(coin, 32, 97, 20);
        graphics.drawString("" + this.bscore, 44, 96, 20);
        int n = 0;
        while (n < 6) {
            BMan bMan = this.npcs[n];
            if (n < 3) {
                graphics.drawImage(hole, 2 + 40 * n, 35, 20);
            } else {
                graphics.drawImage(hole, 2 + 40 * (n - 3), 74, 20);
            }
            if (bMan.work == 5) {
                int n2;
                int n3;
                if (n < 3) {
                    n3 = 3 + 40 * n;
                    n2 = 8;
                } else {
                    n3 = 3 + 40 * (n - 3);
                    n2 = 47;
                }
                if (bMan.npcType >= 0) {
                    if (bMan.aniStep == 4) {
                        graphics.drawImage(star, n3 + 26, n2 - 3, 20);
                    } else if (bMan.aniStep == 5) {
                        graphics.drawImage(star, n3 + 9, n2 - 5, 20);
                    }
                    graphics.drawImage(npcimg[bMan.npcType], n3, n2, 20);
                    graphics.setClip(n3 + 5, n2 + 13, 25, 17);
                    graphics.drawImage(punchimg, n3 + 5 - 25 * bMan.npcType, n2 + 13, 20);
                    graphics.setClip(0, 0, 120, 125);
                    if (bMan.aniStep == 2) {
                        graphics.drawImage(star, n3 - 2, n2 - 1, 20);
                    } else if (bMan.aniStep == 3) {
                        graphics.drawImage(star, n3 + 15, n2 + 5, 20);
                    }
                }
                if (n == this.pressed) {
                    if (bMan.aniStep < 2) {
                        graphics.drawImage(glove, n3 + 5, n2 + 14, 20);
                    } else if (bMan.aniStep < 4) {
                        graphics.drawImage(glove, n3 + 5, n2 + 19, 20);
                    }
                }
            } else if (bMan.npcType >= 0) {
                if (n < 3) {
                    graphics.setClip(3 + 40 * n, 8, 35, 38);
                } else {
                    graphics.setClip(3 + 40 * (n - 3), 47, 35, 38);
                }
                graphics.drawImage(npcimg[bMan.npcType], bMan.x, bMan.y, 20);
                graphics.setClip(0, 0, 120, 125);
            }
            ++n;
        }
        this.temp = this.getTime(this.stime);
        if (this.gState == 11) {
            graphics.drawString("" + this.btime / 1000, 117, 96, 24);
            this.temp = this.count - this.temp;
            if (this.temp < 0) {
                this.update(9);
            } else {
                this.temp = this.temp % 1000 == 0 ? (this.temp /= 1000) : this.temp / 1000 + 1;
                graphics.setColor(0);
                graphics.drawString("BONUS GAME", 60, 6, 17);
                graphics.drawString("READY", 60, 20, 17);
                graphics.setColor(0xFFFFFF);
                graphics.fillRect(56, 56, 9, 11);
                graphics.setColor(0xFF0000);
                graphics.drawString("" + this.temp, 60, 56, 17);
            }
        } else {
            this.temp = this.btime - this.temp;
            this.temp = this.temp <= 0 ? 0 : (this.temp % 1000 == 0 ? (this.temp /= 1000) : this.temp / 1000 + 1);
            graphics.drawString("" + this.temp, 117, 96, 24);
        }
    }

    private void drawGameBg(Graphics graphics) {
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, 120, 125);
        graphics.setColor(2138562);
        graphics.fillRect(0, 58, 120, 67);
        graphics.setColor(0);
        graphics.drawRect(0, 0, 119, 12);
        graphics.drawLine(0, 57, 120, 57);
        graphics.drawString("LV" + this.level, 2, 1, 20);
        graphics.drawImage(coin, 29, 2, 20);
        graphics.drawString("" + this.score, 40, 1, 20);
        graphics.drawImage(heart, 70, 2, 20);
        if (this.life < 10) {
            graphics.drawString("0" + this.life, 80, 1, 20);
        } else {
            graphics.drawString("" + this.life, 80, 1, 20);
        }
        graphics.drawImage(comp, 95, 2, 20);
        if (this.success < 10) {
            graphics.drawString("0" + this.success, 105, 1, 20);
        } else {
            graphics.drawString("" + this.success, 105, 1, 20);
        }
    }

    private void drawHBox(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(0xC0C0C0);
        graphics.fillRect(n + 1, n2 + 7, 25, 11);
        graphics.setColor(0xFFFFFF);
        graphics.drawRect(n, n2, 25, 18);
        graphics.fillRect(n, n2, 25, 7);
        graphics.drawImage(press, n + 1, n2 + 1, 20);
        graphics.setColor(n4);
        graphics.drawString("" + n3, n + 12, n2 + 7, 17);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command != this.bonusCommand) {
            if (command == this.playCommand) {
                this.newLevel(1);
                this.update(3);
            } else if (command == this.nextCommand) {
                this.newLevel(++this.level);
                this.update(3);
            } else if (command == this.retryCommand) {
                this.newLevel(1);
                this.update(3);
            } else if (command == this.exitCommand) {
                this.update(17);
            } else if (command == this.startCommand) {
                this.update(2);
            } else if (command == this.titleCommand) {
                this.update(19);
            } else if (command == this.pauseCommand) {
                this.prevState1 = this.gState;
                this.update(16);
            } else if (command == this.resumeCommand) {
                this.update(this.prevState1);
            } else if (command == this.okCommand) {
                if (this.gState == 19) {
                    this.update(1);
                } else if (this.gState == 17) {
                    this.app.exitGame();
                } else if (this.gState == 3) {
                    this.update(4);
                } else if (this.gState == 15) {
                    this.newLevel(1);
                    this.update(3);
                } else if (this.gState == 11) {
                    this.update(9);
                } else if (this.gState == 13) {
                    this.newLevel(++this.level);
                    this.update(3);
                } else if (this.gState == 18) {
                    this.practice = true;
                    this.newLevel(1);
                    this.update(3);
                }
            } else if (command == this.cancelCommand) {
                System.out.println("prevs - " + this.prevState2);
                this.update(this.prevState2);
            }
        }
    }

    protected void keyReleased(int n) {
    }

    public void keyRepeated(int n) {
        this.keyPressed(n);
    }

    protected void keyPressed(int n) {
        if (n == 42) {
            return;
        }
        if (n == 21 || n == 22) {
            return;
        }
        if (this.gState == 4) {
            BMan bMan = this.npcs[this.hand];
            if (n == 49) {
                this.give(0);
            } else if (n == 50) {
                this.give(1);
            } else if (n == 51) {
                this.give(2);
            } else if (n == 52) {
                if (this.hand > 0) {
                    --this.hand;
                }
            } else if (n == 53) {
                this.take();
            } else if (n == 54) {
                if (this.hand < 2) {
                    ++this.hand;
                }
            } else if (n != 56 && n == 57) {
                // empty if block
            }
        } else if (this.gState == 3 && n == -5) {
            this.update(4);
        } else if (this.gState == 5 && n == -5) {
            this.newLevel(++this.level);
            this.update(3);
        } else if ((this.gState == 7 || this.gState == 6) && n == -5) {
            this.newLevel(1);
            this.update(3);
        } else if (this.gState == 11 && n == -5) {
            this.update(9);
        } else if (this.gState == 13 && n == -5) {
            this.newLevel(++this.level);
            this.update(3);
        } else if (this.gState == 9) {
            if (n >= 49 && n <= 54) {
                this.punchNPC(n - 49);
            } else if (n == 57) {
                this.newLevel(++this.level);
                this.update(3);
            }
        } else if (this.gState == 2) {
            if (n == -1) {
                this.selidx = this.selidx > 0 ? --this.selidx : 3;
                this.repaint();
            } else if (n == -2) {
                this.selidx = this.selidx < 3 ? ++this.selidx : 0;
                this.repaint();
            } else if (n == -5 && this.selidx == 0) {
                if (this.showintro) {
                    this.showintro = true;
                    this.update(15);
                } else {
                    this.practice = false;
                    this.newLevel(1);
                    this.update(3);
                }
            } else if (n == -5 && this.selidx == 1) {
                this.update(18);
            } else if (n == -5 && this.selidx == 2) {
                this.update(14);
            } else if (n == -5 && this.selidx == 3) {
                this.update(17);
            }
        } else if (this.gState == 15) {
            if (n == -5) {
                this.practice = false;
                this.newLevel(1);
                this.update(3);
            }
        } else if (this.gState == 18) {
            if (this.selidx == 0 && n == 52) {
                this.hand = 0;
                ++this.selidx;
            } else if (this.selidx == 1 && n == 54) {
                this.hand = 1;
                ++this.selidx;
            } else if (this.selidx == 2 && n == 53 && this.npcs[1].work == 1 && this.npcs[1].obj == 0) {
                this.take();
            } else if (this.selidx == 3 && n == 49 && this.npcs[1].work == 3 && this.npcs[1].obj == 0) {
                this.give(0);
            } else if (this.selidx == 4 && n == 53 && this.npcs[1].work == 1 && this.npcs[1].obj == 2) {
                this.take();
            } else if (this.selidx == 5 && n == 50 && this.npcs[1].work == 3 && this.npcs[1].obj == 1) {
                this.give(1);
            } else if (this.selidx == 6 && n == 53 && this.npcs[1].work == 1 && this.npcs[1].obj == 1) {
                this.take();
            } else if (this.selidx == 7 && n == 51 && this.npcs[1].work == 3 && this.npcs[1].obj == 2) {
                this.give(2);
                this.removeAllCommands();
                this.addCommand(this.okCommand);
                this.addCommand(this.startCommand);
            } else if (this.selidx == 8 && n == -5) {
                this.practice = true;
                this.newLevel(1);
                this.update(3);
            }
        } else if (this.gState == 14) {
            if (n == -1) {
                if (this.selidx > 0) {
                    --this.selidx;
                    this.repaint();
                }
            } else if (n == -2 && this.selidx < 3) {
                ++this.selidx;
                this.repaint();
            }
        } else if (this.gState == 1) {
            this.update(2);
        }
    }

    private void take() {
        BMan bMan = this.npcs[this.hand];
        if (bMan.work == 1) {
            bMan.gave = bMan.obj;
            bMan.work = 2;
        } else if (bMan.work == 3) {
            this.score -= 20;
            if (this.score < 0) {
                this.score = 0;
            }
            --bMan.trust;
            bMan.aniStep = -4;
            bMan.gave = 4;
            bMan.work = 5;
        }
    }

    private void give(int n) {
        BMan bMan = this.npcs[this.hand];
        if (bMan.work == 3) {
            bMan.obj = n;
            bMan.objy = 100;
            if (n == this.returnFor(bMan.gave)) {
                this.score = n == 0 ? (this.score += 10) : (this.score += 15);
                ++bMan.trust;
                bMan.aniStep = 4;
            } else {
                this.score -= 20;
                if (this.score < 0) {
                    this.score = 0;
                }
                --bMan.trust;
                bMan.aniStep = -4;
            }
            bMan.gave = 4;
            bMan.work = 4;
        } else if (bMan.work == 1) {
            this.score -= 20;
            if (this.score < 0) {
                this.score = 0;
            }
            --bMan.trust;
            bMan.aniStep = -4;
            bMan.gave = 4;
            bMan.work = 5;
        }
    }

    private void punchNPC(int n) {
        if (n < 0 || n > 5) {
            return;
        }
        this.pressed = n;
        BMan bMan = this.npcs[n];
        if (bMan.npcType >= 0) {
            if (bMan.work != 5) {
                bMan.work = 5;
                bMan.aniStep = 0;
                this.bscore += 5;
                this.blife = this.bscore / 100;
                this.playSound(5);
            }
        } else {
            bMan.work = 5;
            bMan.aniStep = 0;
            this.playSound(6);
        }
    }

    public void run() {
        while (this.loop) {
            Screen screen = this;
            synchronized (screen) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!this.lock) {
                    if (this.gState == 4) {
                        this.runGame();
                        this.repaint();
                    } else if (this.gState == 9) {
                        this.temp = this.getTime(this.stime);
                        this.temp = this.btime - this.temp;
                        if (this.temp <= 0) {
                            this.score += this.bscore;
                            this.life += this.blife;
                            this.update(13);
                        } else {
                            this.runGame2();
                            this.repaint();
                        }
                    } else if (this.gState == 11) {
                        this.repaint();
                    } else if (this.gState == 3) {
                        this.temp = this.getTime(this.stime);
                        this.temp = 3000 - this.temp;
                        if (this.temp <= 0) {
                            this.update(4);
                        }
                    } else if (this.gState == 1) {
                        try {
                            Thread.sleep(400L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.repaint();
                    } else if (this.gState == 14) {
                        try {
                            Thread.sleep(400L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.repaint();
                    } else if (this.gState == 18) {
                        if (this.npcs[1].work == 2) {
                            this.npcs[1].objy += 13;
                            if (this.npcs[1].objy > 100) {
                                this.npcs[1].work = 0;
                                ++this.selidx;
                            }
                        } else if (this.npcs[1].work == 4) {
                            this.npcs[1].objy -= 13;
                            if (this.npcs[1].objy < 59) {
                                this.npcs[1].work = 5;
                                ++this.selidx;
                            }
                        } else if (this.npcs[1].work == 0 && this.npcs[1].trust >= 3) {
                            ++this.success;
                            this.npcs[1].reset(this.newNPC(3), Screen.throwDice(3));
                        }
                        if (this.selidx >= 2 && this.npcs[1].work == 0) {
                            if (this.selidx % 2 != 0) {
                                this.npcs[1].request(3, this.returnFor(this.npcs[1].gave), 0);
                            } else if (this.selidx == 2) {
                                this.npcs[1].request(1, 0, 0);
                            } else if (this.selidx == 4) {
                                this.npcs[1].request(1, 2, 0);
                            } else if (this.selidx == 6) {
                                this.npcs[1].request(1, 1, 0);
                            }
                        }
                        this.repaint();
                    } else if (this.gState == 0 && !this.loaded) {
                        this.loaded = true;
                        this.loadRes();
                        loadmsg = null;
                        this.update(1);
                    }
                }
            }
        }
        return;
    }

    private void runGame() {
        BMan bMan;
        int n = 0;
        while (n < 3) {
            bMan = this.npcs[n];
            if (bMan.work == 2) {
                bMan.objy += 10;
                if (bMan.objy > 100) {
                    if (bMan.obj == 3) {
                        this.score -= 20;
                        if (this.score < 0) {
                            this.score = 0;
                        }
                        --bMan.trust;
                        bMan.aniStep = -4;
                        bMan.work = 5;
                    } else {
                        bMan.work = 0;
                    }
                }
            } else if (bMan.work == 4) {
                bMan.objy -= 10;
                if (bMan.objy < 59) {
                    bMan.work = 5;
                }
            } else if (bMan.work == 0) {
                if (bMan.trust <= -1) {
                    if (this.life == 0) {
                        this.update(7);
                        return;
                    }
                    --this.life;
                    bMan.reset(this.newNPC(3), Screen.throwDice(3));
                } else if (bMan.trust >= 3) {
                    ++this.success;
                    if (this.success >= this.clrcond) {
                        if (this.practice && this.level >= 6 || !this.practice && this.level >= 15) {
                            this.update(6);
                        } else {
                            this.update(5);
                        }
                        return;
                    }
                    bMan.reset(this.newNPC(3), Screen.throwDice(3));
                }
            } else if (bMan.work == 1 || bMan.work == 3) {
                bMan.time += 100;
                if (bMan.obj == 3) {
                    if (bMan.time >= this.wtime || bMan.time >= 800) {
                        bMan.work = 0;
                    }
                } else if (bMan.time >= this.wtime) {
                    this.score -= 20;
                    if (this.score < 0) {
                        this.score = 0;
                    }
                    --bMan.trust;
                    bMan.aniStep = -4;
                    bMan.gave = 4;
                    bMan.work = 5;
                }
            }
            ++n;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < 3) {
            if (this.npcs[n4].work == 0) {
                ++n2;
            }
            ++n4;
        }
        ++this.timer;
        if (3 - n2 < this.once) {
            if (this.winsize == 2 && this.once == 2 && this.timer < 7) {
                return;
            }
            this.timer = 0;
            int n5 = 0;
            while (n5 < 3) {
                bMan = this.npcs[n5];
                if (bMan.work == 0 && bMan.gave < 3) {
                    if (this.TID - bMan.TID >= this.winsize) {
                        bMan.request(3, this.returnFor(bMan.gave), this.TID++);
                        return;
                    }
                    ++n3;
                }
                ++n5;
            }
            if (n3 > 0 && Screen.throwDice(5) == 0) {
                this.timer = 0;
                do {
                    bMan = this.npcs[Screen.throwDice(3)];
                } while (bMan.work != 0 || bMan.gave >= 3);
                bMan.request(3, this.returnFor(bMan.gave), this.TID++);
            } else if (n2 > n3) {
                do {
                    bMan = this.npcs[Screen.throwDice(3)];
                } while (bMan.work != 0 || bMan.gave < 3);
                this.temp = Screen.throwDice(10) == 4 ? 3 : (this.practice ? (this.level <= 2 ? 0 : (this.level <= 4 ? 2 : (this.level <= 6 ? 1 : Screen.throwDice(3)))) : Screen.throwDice(3));
                bMan.request(1, this.temp, this.TID++);
            }
        }
    }

    private void runGame2() {
        BMan bMan;
        this.temp = 0;
        int n = 0;
        while (n < 6) {
            bMan = this.npcs[n];
            if (bMan.work == 5) {
                if (bMan.npcType >= 0) {
                    if (bMan.aniStep < 6) {
                        ++bMan.aniStep;
                        ++this.temp;
                    } else {
                        bMan.npcType = -1;
                        bMan.work = 0;
                    }
                } else if (bMan.aniStep < 4) {
                    ++bMan.aniStep;
                } else {
                    bMan.work = 0;
                }
            } else if (bMan.npcType >= 0) {
                if (bMan.aniStep < 4) {
                    if (bMan.aniStep == 0) {
                        bMan.y -= 5;
                        if (n < 3) {
                            if (bMan.y <= 8) {
                                bMan.y = 8;
                                ++bMan.aniStep;
                            }
                        } else if (bMan.y <= 47) {
                            bMan.y = 47;
                            ++bMan.aniStep;
                        }
                    } else if (bMan.aniStep == 3) {
                        bMan.y += 5;
                        if (n < 3) {
                            if (bMan.y >= 35) {
                                bMan.y = 35;
                                ++bMan.aniStep;
                            }
                        } else if (bMan.y <= 74) {
                            bMan.y = 74;
                            ++bMan.aniStep;
                        }
                    } else {
                        ++bMan.aniStep;
                    }
                    ++this.temp;
                } else {
                    bMan.npcType = -1;
                }
            }
            ++n;
        }
        if (this.temp < 3 && Screen.throwDice(5) == 1) {
            do {
                this.temp = Screen.throwDice(6);
                bMan = this.npcs[this.temp];
            } while (bMan.npcType >= 0);
            bMan.npcType = this.newNPC(6);
            if (this.temp < 3) {
                bMan.resetPos(2 + 40 * this.temp, 35);
            } else {
                bMan.resetPos(2 + 40 * (this.temp - 3), 74);
            }
            bMan.aniStep = 0;
        }
    }

    public void newLevel(int n) {
        this.level = n;
        this.hand = 1;
        if (n == 1) {
            this.life = 10;
            this.score = 0;
        }
        this.success = 0;
        this.timer = 0;
        int n2 = 0;
        while (n2 < 3) {
            this.npcs[n2].reset(this.newNPC(3), Screen.throwDice(3));
            this.npcs[n2].resetPos(3 + n2 * 38, 19);
            ++n2;
        }
        if (this.practice) {
            if (n <= 6) {
                this.winsize = winsize_data[n - 1];
                this.once = once_data[n - 1];
                this.wtime = wtime_data[n - 1];
                this.clrcond = clrcond_data[n - 1];
            }
        } else if (n <= 15) {
            this.winsize = winsize_data[5 + n];
            this.once = once_data[5 + n];
            this.wtime = wtime_data[5 + n];
            this.clrcond = clrcond_data[5 + n];
        }
    }

    private int newNPC(int n) {
        int n2 = -1;
        int n3 = 0;
        do {
            n2 = Screen.throwDice(5);
            n3 = 0;
            while (n3 < n) {
                if (this.npcs[n3].npcType >= 0 && this.npcs[n3].npcType == n2) {
                    n2 = -1;
                }
                ++n3;
            }
        } while (n2 < 0);
        return n2;
    }

    private int returnFor(int n) {
        if (n == 2) {
            return 1;
        }
        if (n == 1) {
            return 2;
        }
        if (n == 0) {
            return 0;
        }
        return 4;
    }

    public static int throwDice(int n) {
        return Math.abs(rnd.nextInt() % n);
    }

    public void destroy() {
    }

    private int getTime(int n) {
        this.date = new Date();
        int n2 = (int)this.date.getTime();
        return n2 - n;
    }

    private Image loadImage(String string) {
        try {
            ++this.progress;
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.repaint();
            return Image.createImage((String)("/image/" + string));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void loadRes() {
        title = this.loadImage("title.png");
        logo = this.loadImage("logo.png");
        tail = this.loadImage("tail.png");
        corner = this.loadImage("corner.png");
        npcimg = new Image[]{this.loadImage("npc1.png"), this.loadImage("npc2.png"), this.loadImage("npc3.png"), this.loadImage("npc4.png"), this.loadImage("npc5.png")};
        goodimg = this.loadImage("good.png");
        badimg = this.loadImage("bad.png");
        punchimg = this.loadImage("punch.png");
        cardimg = this.loadImage("card.png");
        handimg1 = this.loadImage("hand1.png");
        handimg2 = this.loadImage("hand2.png");
        money = this.loadImage("money.png");
        goods = this.loadImage("goods.png");
        trash = this.loadImage("trash.png");
        comp = this.loadImage("comp.png");
        heart = this.loadImage("heart.png");
        coin = this.loadImage("coin.png");
        hole = this.loadImage("hole.png");
        glove = this.loadImage("glove.png");
        star = this.loadImage("star.png");
        text = this.loadImage("text.png");
        msgbonus = this.loadImage("bonus.png");
        msghelp = this.loadImage("help.png");
        btn = this.loadImage("btn.png");
        press = this.loadImage("press.png");
        key6 = this.loadImage("key6.png");
        imgSndOff = this.loadImage("sndoff.png");
    }

    static {
        helpdoc = new String[]{"\uba85\ud568\uc8fc\uae30", "\ub3c8\uc8fc\uae30", "\ubb3c\uac74\uc8fc\uae30", "\uc88c\uc6b0\uc774\ub3d9", "\ubc1b\uae30", "\uace0\uac1d\ub4e4\uc758 \uc694\uad6c\uc5d0 \ub530", "\ub77c \uac70\ub798\ub97c \ud55c\ub2e4.", "\ub3c8\uc744 \ubc1b\uc73c\uba74 \ubb3c\uac74,", "\ubb3c\uac74\uc744 \ubc1b\uc73c\uba74 \ub3c8,", "\uba85\ud568\uc744 \ubc1b\uc73c\uba74 \uba85\ud568", "\uc744 \uc8fc\uc5b4\uc57c \ud55c\ub2e4.", "", "\ud544\uc694\ud55c \uac74 \uae30\uc5b5\ub825", "\uc21c\ubc1c\ub825!", "", "", "", "", ""};
        introdoc = new String[]{"4,6: \uc774\ub3d9", "5: \ubc1b\uae30", "1: \uba85\ud568\uc8fc\uae30", "2: \ub3c8\uc8fc\uae30", "3: \ubb3c\uac74\uc8fc\uae30", ""};
        winsize_data = new int[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4};
        once_data = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 2, 2, 2, 2, 2, 1, 1, 2, 2};
        wtime_data = new int[]{3000, 3000, 3000, 3000, 3000, 3000, 2000, 1500, 1500, 1000, 1500, 1000, 2000, 1500, 1500, 1000, 1000, 1000, 1000, 1500, 1500};
        clrcond_data = new int[]{2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 5, 3, 5, 7, 5, 7, 5, 7, 5, 7};
    }
}

